local Image = require("widgets/image")
local Text = require("widgets/text")
local Widget = require("widgets/widget")
local ItemLevelBadge = require("widgets/ftf/itemlevelbadge")

local itemcatalog = require "defs.itemcatalog"
local fmodtable = require "defs.sound.fmodtable"


local ItemWidget = Class(Widget, function(self, item_def, count, size)
	Widget._ctor(self, "ItemWidget")

	-- sound
	self:SetControlDownSound(nil)
	self:SetControlUpSound(nil)
	self:SetHoverSound(fmodtable.Event.hover)
	self:SetGainFocusSound(fmodtable.Event.hover)

	self.size = size or 130 * HACK_FOR_4K

	self.mask = self:AddChild(Image("images/ui_ftf_shop/inventory_slot_bg.tex"))
		:SetMask()

	self.background = self:AddChild(Image("images/ui_ftf_shop/inventory_slot_bg.tex"))
		:SetMasked()

	self.icon = self:AddChild(Image("images/ui_ftf_shop/inventory_slot_bg.tex"))
		:SetMasked()

	-- Add quantity
	self.quantity = self:AddChild(Text(FONTFACE.DEFAULT, 30 * HACK_FOR_4K, "", UICOLORS.LIGHT_TEXT_TITLE))
		:SetOutlineColor(UICOLORS.BACKGROUND_LIGHT)
		:EnableOutline(0.00001)

	self.bonus_icon = self:AddChild(Image("images/ui_ftf_dialog/convo_quest.tex"))
		:SetMultColor(RGB(254, 200, 11))
		:SetToolTip("Bonus Loot!")
		:SetHiddenBoundingBox(true)
		:Hide()

	self.level_badge = self:AddChild(ItemLevelBadge(self.size))
		:SetName("Level badge")
		:SetHiddenBoundingBox(true)
		:Hide()

	if item_def then
		self:SetItem(item_def, count)
	end

	self:SetSize(self.size)
end)

function ItemWidget:SetItem(itemdef, count, item_level)
	if itemdef then
		self.itemdef = itemdef
		count = count or 1
		-- Set rarity-specific background
		self:_SetRarity(itemdef.rarity or ITEM_RARITY.s.COMMON)

		self.icon:SetTexture(itemdef.icon)
			:SetMultColor(UICOLORS.WHITE)
			:SetMultColorAlpha(1)

		self:SetToolTip( string.format("%s (x%s)", itemdef.pretty.name, count))

		-- Show quantity if available
		self.quantity:SetText(count)

		-- Show item level
		self.level_badge:SetItem(nil, item_level)
			:SetShown(item_level)
	else
		self.level_badge:Hide()
	end

	self:Layout()
    return self
end

function ItemWidget:SetEmptySlot(slot)
	local descriptors = itemcatalog.All.SlotDescriptor

	self.background:SetTexture("images/ui_ftf_shop/inventory_slot_bg.tex")
		:SetMultColor(0xEFE9E6ff)

	self.icon:SetTexture(descriptors[slot].icon)
		:SetMultColor(UICOLORS.DARK_TEXT)
		:SetMultColorAlpha(0.4)

	return self
end

function ItemWidget:SetBonus()
	self.bonus_icon:Show()

	self.bonus_icon:LayoutBounds("right", "top", self.background)
		-- :Offset(-12 * HACK_FOR_4K, -15 * HACK_FOR_4K)

	return self
end

function ItemWidget:_SetRarity(rarity)
	local tex = itemcatalog.GetRarityIcon(rarity)
	self.background:SetTexture(tex)
	self.rarity = rarity
	return self
end

function ItemWidget:GetSizeVar()
	return self.size
end

function ItemWidget:SetSize(size)
	self.size = size

	self.mask:SetSize(self.size, self.size)
	self.background:SetSize(self.size, self.size)
	self.icon:SetSize(self.size, self.size)
	self.bonus_icon:SetSize(self.size * 0.33, self.size * 0.33)
	self.level_badge:SetSize(self.size * .35)
	self:Layout()

	return self
end

function ItemWidget:HideQuantity()
	self.quantity:Hide()
	return self
end

function ItemWidget:Layout()
	self.quantity:LayoutBounds("right", "bottom", self.background)
		:Offset(-self.size * .06, self.size * .01)
	self.level_badge:LayoutBounds("right", "bottom", self.background)
		:Offset(0, self.size * .01)
	return self
end


return ItemWidget
